/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render;

import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzLayerRenderer;
import mod.azure.azurelib.common.render.AzModelRenderer;
import mod.azure.azurelib.common.render.AzPhasedRenderer;
import mod.azure.azurelib.common.render.AzRendererConfig;
import mod.azure.azurelib.common.render.AzRendererPipelineContext;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipeline<K, T>
implements AzPhasedRenderer<K, T> {
    protected final AzRendererConfig<K, T> config;
    private final AzRendererPipelineContext<K, T> context;
    private final AzLayerRenderer<K, T> layerRenderer;
    private final AzModelRenderer<K, T> modelRenderer;

    protected AzRendererPipeline(AzRendererConfig<K, T> config) {
        this.config = config;
        this.context = this.createContext(this);
        this.layerRenderer = this.createLayerRenderer(config);
        this.modelRenderer = this.createModelRenderer(this.layerRenderer);
    }

    protected abstract AzRendererPipelineContext<K, T> createContext(AzRendererPipeline<K, T> var1);

    protected abstract AzModelRenderer<K, T> createModelRenderer(AzLayerRenderer<K, T> var1);

    protected abstract AzLayerRenderer<K, T> createLayerRenderer(AzRendererConfig<K, T> var1);

    public abstract void updateAnimatedTextureFrame(T var1);

    public void render(class_4587 poseStack, AzBakedModel model, T animatable, class_4597 bufferSource, @Nullable class_1921 renderType, @Nullable class_4588 buffer, float yaw, float partialTick, int packedLight) {
        renderType = this.context.getDefaultRenderType(animatable, this.config.textureLocation(this.context.currentEntity, animatable), bufferSource, partialTick, this.config.getRenderType(this.context.currentEntity, animatable), this.config.alpha(animatable));
        this.context.populate(animatable, model, bufferSource, packedLight, partialTick, poseStack, renderType, buffer);
        poseStack.method_22903();
        this.preRender(this.context, false);
        this.layerRenderer.preApplyRenderLayers(this.context);
        this.modelRenderer.cacheTexture(this.context);
        this.modelRenderer.render(this.context, false);
        this.modelRenderer.clearCacheTexture();
        this.layerRenderer.applyRenderLayers(this.context);
        this.postRender(this.context, false);
        poseStack.method_22909();
        this.renderFinal(this.context);
        this.doPostRenderCleanup(this.context);
    }

    public void reRender(AzRendererPipelineContext<K, T> context) {
        class_4587 poseStack = context.poseStack();
        poseStack.method_22903();
        this.preRender(context, true);
        this.modelRenderer.render(context, true);
        this.postRender(context, true);
        poseStack.method_22909();
    }

    protected void renderFinal(AzRendererPipelineContext<K, T> context) {
    }

    protected void doPostRenderCleanup(AzRendererPipelineContext<K, T> context) {
    }

    protected void scaleModelForRender(AzRendererPipelineContext<K, T> context, float widthScale, float heightScale, boolean isReRender) {
        if (!(isReRender || widthScale == 1.0f && heightScale == 1.0f)) {
            class_4587 poseStack = context.poseStack();
            poseStack.method_22905(widthScale, heightScale, widthScale);
        }
    }

    public AzRendererConfig<K, T> config() {
        return this.config;
    }

    public AzRendererPipelineContext<K, T> context() {
        return this.context;
    }
}

